# image.shear()

Shears an image either horizontally or vertically.

```
image.shear( shear=number, direction=string, interpolation=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| shear | number | Yes | Shear value. Coordinates can be integers or real numbers. |  |
| direction | string | No | Shear direction: - horizontal (default) - vertical |  |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. |  |

# Examples

```cfml
	img = imageNew("",100,80,"rgb","B33771");
	img.Shear(4,"vertical");
	cfimage(action="writeToBrowser", source=img);
	img.Shear(4);
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageShear()](../../functions/imageshear.md), [Image](../image.md)