# image.sharpen()

Sharpens a image by using the unsharp mask filter.

```
image.sharpen( gain=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| gain | number | No | Gain values can be integers or real numbers. The default value is 1.0. The value determines whether the image is blurred or sharpened: - if > 0, the image is sharpened - if = 0, no effect - if < 0, the image is blurred |  |

# Examples

```cfml
	img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.Sharpen(2);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageSharpen()](../../functions/imagesharpen.md), [Image](../image.md)