# image.setDrawingColor()

Sets the current drawing color for images. All subsequent graphics operations use the specified color.

```
image.setDrawingColor( color=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| color | string | Yes | Drawing color (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. *Alias: colour* |  |

# Examples

```cfml
	img=imageread("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.SetDrawingColor("black");
	ImageDrawLine(img,0,0,300,200)
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageSetDrawingColor()](../../functions/imagesetdrawingcolor.md), [Image](../image.md)