# image.setDrawingAlpha()

Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.

```
image.setDrawingAlpha( alpha=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| alpha | number | Yes | a floating point number in range 0-1 |  |

# Examples

```cfml
	img=imageNew("", 250, 250, "RGB", "a29bfe");

	img.setDrawingAlpha(0.3);
	img.drawRect(50, 50, 50, 50);

	img.setDrawingAlpha(0.6);
	img.drawRect(75, 75, 75, 75);

	img.setDrawingAlpha(1);
	img.drawRect(100, 100, 100, 100);

	writeOutput(img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageSetDrawingAlpha()](../../functions/imagesetdrawingalpha.md), [Image](../image.md)