# image.setBackgroundColor()

Sets the background color for the image. The background color is used for clearing a region. Setting the background color only affects the subsequent ImageClearRect calls

```
image.setBackgroundColor( color=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| color | string | Yes | Background color (The default value is "black"): - Hexadecimal value of RGB color. For example, specify the color white as ##FFFFFF or FFFFFF. - String value of color (for example, "black", "red", "green"). - List of three numbers for (R,G,B) values. Each value must be in the range 0-255. *Alias: colour* |  |

# Examples

```cfml
	img=imageread("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.SetBackGroundColor("red");
	img.ClearRect(20,20,70,50);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageSetBackgroundColor()](../../functions/imagesetbackgroundcolor.md), [Image](../image.md)