# image.scaleToFit()

Creates a resized image with the aspect ratio maintained.

```
image.scaleToFit( fitWidth=string, fitHeight=string, interpolation=string, blurFactor=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| fitWidth | string | Yes | The width of the bounding box in pixels. You can specify an integer, or an empty string ("") if the fitHeight is specified. |  |
| fitHeight | string | Yes | The height of the bounding box in pixels. You can specify an integer, or an empty string ("") if the fitWidth is specified. |  |
| interpolation | string | No | The interpolation method for resampling. You can specify a specific interpolation algorithm by name (for example, hamming), by image quality (for example, mediumQuality), or by performance (for example, highestPerformance). Valid values are: - highestQuality (default) - highQuality - mediumQuality - highestPerformance - highPerformance - mediumPerformance - nearest - bilinear - bicubic - bessel - blackman - hamming - hanning - hermite - lanczos - mitchell - quadratic |  |
| blurFactor | number | No | The blur factor used for resampling. The higher the blur factor, the more blurred the image (also, the longer it takes to resize the image). Valid values are 1-10. |  |

# Examples

```cfml
	myImg = imageNew("",400,400,"rgb","70a1ff");
	myImg.ScaleToFit(80,"","highPerformance");
	cfimage(action="writeToBrowser", source=myImg);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageScaleToFit()](../../functions/imagescaletofit.md), [Image](../image.md)