# image.rotateDrawingAxis()

Rotates all subsequent drawing on a image at a specified point by a specified angle.

```
image.rotateDrawingAxis( angle=number, x=number, y=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| angle | number | No | The rotation angle in degrees. |  |
| x | number | No | The x coordinate for the point of rotation. The default value is 0. |  |
| y | number | No | The y coordinate for the point of rotation. The default value is 0. |  |

# Examples

```cfml
	imgObj = imageNew("",152,152,"rgb","##bf4f36");
	imgObj.rotateDrawingAxis(75,71,71);
	imgObj.drawLines([0,38,76,114,152],[0,152,0,152,0],"no","no");
	cfimage(action="writeToBrowser", source=imgObj);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageRotateDrawingAxis()](../../functions/imagerotatedrawingaxis.md), [Image](../image.md)