# image.rotate()

Rotates a image at a specified point by a specified angle.

```
image.rotate( x=string, y=string, angle=string, interpolation=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | string | Yes | The x coordinate for the point of rotation. The default value is 2. |  |
| y | string | No | The y coordinate for the point of rotation. The default value is 2. |  |
| angle | string | No | The rotation angle in degrees. |  |
| interpolation | string | No | Type of interpolation: - nearest (default): Applies the nearest neighbor method of interpolation. Image quality is lower than the other interpolation methods, but processing is fastest. - bilinear: Applies the bilinear method of interpolation. The quality of the image is less pixelated than the default, but processing is slower. - bicubic: Applies the bicubic method of interpolation. Generally, the quality of image is highest with this method and processing is slowest. |  |

# Examples

```cfml
	imgObj = imageNew("",200,200,"rgb","red");
	imgObj.rotate(50,50,60,"bilinear");
	cfimage(action = "writeToBrowser",source = imgObj);
	writeoutput("<br><br>");
	img1 = imageNew("",100,100,"RGB","blue");
	img1.rotate(60,40,120);
	cfimage(action = "writeToBrowser",source = img1);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageRotate()](../../functions/imagerotate.md), [Image](../image.md)