# image.resize()

Resizes a image.

```
image.resize( width=string, height=string, interpolation=string, blurFactor=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| width | string | Yes | New width of the image. If this value is blank, the width is calculated proportionately to the height. |  |
| height | string | No | New height of the image. If this value is blank, the height is calculated proportionately to the width. |  |
| interpolation | string | No | the interpolation method for resampling. You can specify a specific interpolation algorithm by name (for example, hamming), by image quality (for example, mediumQuality), or by performance (for example, highestPerformance). Valid values are: - highestQuality (default) - highQuality - mediumQuality - highestPerformance - highPerformance - mediumPerformance - nearest - bilinear - bicubic - bessel - blackman - hamming - hanning - hermite - lanczos - mitchell - quadratic |  |
| blurFactor | number | No | The blur factor used for resampling. The higher the blur factor, the more blurred the image (also, the longer it takes to resize the image). Valid values are 1-10. |  |

# Examples

```cfml
	img=imageNew("",200,200,"RGB","blue");
	cfimage(action="writeToBrowser",source=img);writeoutput("</br>");
	img.resize( "20%","100");
	cfimage(action="writeToBrowser",source=img);writeoutput("</br>");
	img.resize( "20%","75");writeoutput("</br>");
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageResize()](../../functions/imageresize.md), [Image](../image.md)