# image.paste()

Takes two images and an (x,y) coordinate and draws the second image over the first image with the upper-left corner at coordinate (x,y).

```
image.paste( image2=any, x=number, y=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| image2 | any | Yes | The image that is pasted on top of image1. |  |
| x | number | No | The x coordinate where the upper-left corner of image2 is pasted. |  |
| y | number | No | The y coordinate where the upper-left corner of image2 is pasted. |  |

# Examples

```cfml
	firstImage = imageNew("",200,200,"rgb","red");
	secondImage = imageNew("",200,200,"rgb","yellow");
	firstImage.paste(secondImage,75,39);
	thirdimage = imageNew("",50,50,"rgb","blue");
	firstImage.paste(thirdimage,20,39);
	cfimage(action="writeToBrowser", source=firstImage);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImagePaste()](../../functions/imagepaste.md), [Image](../image.md)