# image.overlay()

Reads two source images and overlays the second source image on the first source image.

```
image.overlay( source2=any )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| source2 | any | Yes | the image that is the top layer (overlaid on the source1 image) in the image. |  |

# Examples

```cfml
	myImg = imageNew("",152,152,"rgb","40739e");
	topImg = imageNew("",80,80,"rgb","fbc531");
	myImg.overlay(topImg);
	cfimage(action="writeToBrowser", source=myImg);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageOverlay()](../../functions/imageoverlay.md), [Image](../image.md)