# image.getEXIFTag()

Retrieves the specified EXIF tag in an image.

```
image.getEXIFTag( tagName=string )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| tagName | string | Yes | The EXIF tag name to be returned. |  |

# Examples

```cfml
	img = imageNew("", 105, 100, "rgb", "yellow");
	writeDump(img.GetEXIFTag('width'));
	writeDump(img.GetEXIFTag('height'));
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageGetEXIFTag()](../../functions/imagegetexiftag.md), [Image](../image.md)