# image.flip()

Flips an image across an axis.

```
image.flip( transpose=string )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| transpose | string | No | Transpose the image: - vertical (default): Flip an image across an imaginary horizontal line that runs through the center of the image. - horizontal: Flip an image across an imaginary vertical line that runs through the center of the image. - diagonal: Flip an image across its main diagonal that runs from the upper-left to the lower-right corner. - antidiagonal: Flip an image across its main diagonal that runs from the upper-right to the lower-left corner. - ("90\|180\|270"): Rotate an image clockwise by 90, 180, or 270 degrees. |  |

# Examples

```cfml
	img = imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.Flip("antidiagonal");
	cfimage(action = "writeToBrowser",source = img);writeoutput("</br>");
	img = imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.Flip("diagonal");
	cfimage(action = "writeToBrowser",source = img);writeoutput("</br>");
	img = imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
	img.Flip("vertical");
	cfimage(action = "writeToBrowser",source = img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageFlip()](../../functions/imageflip.md), [Image](../image.md)