# image.drawText()

Draws a text string on a image with the baseline of the first character positioned at (x,y) in the image.

```
image.drawText( string=string, x=number, y=number, attributeCollection=struct )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| string | string | Yes | the text to draw. *Alias: str* |  |
| x | number | Yes | The x coordinate for the start point of the string. |  |
| y | number | Yes | The y coordinate for the start point of the string. |  |
| attributeCollection | struct | No | A structure used to specify the text characteristics. the following keys are supported: - font: The name of the font used to draw the text string. If you do not specify the font attribute, the text is drawn in the default system font. - size: The font size for the text string. The default value is 10 points. - style: The style to apply to the font ( bold,italic,boldItalic,plain (default) ). - strikethrough: a boolean that specify whether strikethrough is applied to the text image, default is false. - underline: a boolean that specify whether underline is applied to the text image, default is false. |  |

# Examples

```cfml
	img=imageNew("",300,300,"RGB","##bf4f36");
	style={size="40",style="BOLD"};
	img.DrawText("I love lucee",55,120,style);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawText()](../../functions/imagedrawtext.md), [Image](../image.md)