# image.drawRoundRect()

Draws a rectangle with rounded corners.

```
image.drawRoundRect( x=number, y=number, width=number, height=number, arcWidth=number, arcHeight=number, filled=boolean )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the rectangle. |  |
| y | number | Yes | The y coordinate of the rectangle. |  |
| width | number | Yes | The width of the rectangle. |  |
| height | number | Yes | The height of the rectangle. |  |
| arcWidth | number | Yes | The horizontal diameter of the arc at the four corners. |  |
| arcHeight | number | Yes | The vertical diameter of the arc at the four corners. |  |
| filled | boolean | No | Specify whether the rectangle is filled: - true: The rectangle is filled with the specified drawing color. - false (default): Only the outline of the rectangle is drawn. |  |

# Examples

```cfml
	img=imageNew("",200,200,"RGB","b71540");
	img.DrawRoundRect(55,45,75,65,75,25);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawRoundRect()](../../functions/imagedrawroundrect.md), [Image](../image.md)