# image.drawRect()

Draws a rectangle.

```
image.drawRect( x=number, y=number, width=number, height=number, filled=boolean )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the rectangle. |  |
| y | number | Yes | The y coordinate of the rectangle. |  |
| width | number | Yes | The width of the rectangle. |  |
| height | number | Yes | The height of the rectangle. |  |
| filled | boolean | No | Specify whether the rectangle is filled: - true: The rectangle is filled with the specified drawing color. - false (default): Only the outline of the rectangle is drawn. |  |

# Examples

```cfml
	img=imageNew("",200,200,"RGB","00fcfc");
	img.DrawRect(45,50,75,125);
	img.DrawRect(70,50,75,10);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawRect()](../../functions/imagedrawrect.md), [Image](../image.md)