# image.drawQuadraticCurve()

Draws a curved line. The curve is controlled by a single point.

```
image.drawQuadraticCurve( x1=number, y1=number, ctrlx=number, ctrly=number, x2=number, y2=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x1 | number | Yes | The x coordinate of the start point of the quadratic curve segment. |  |
| y1 | number | Yes | The y coordinate of the start point of the quadratic curve segment. |  |
| ctrlx | number | Yes | The x coordinate of the first control point of the quadratic curve segment. |  |
| ctrly | number | Yes | The y coordinate of the first control point of the quadratic curve segment. |  |
| x2 | number | Yes | The x coordinate of the end point of the quadratic curve segment. |  |
| y2 | number | Yes | The y coordinate of the end point of the quadratic curve segment. |  |

# Examples

```cfml
	img=imageNew("",100,100,"RGB","a29bfe");
	img.DrawQuadraticCurve(0,40,50,0,88,80);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawQuadraticCurve()](../../functions/imagedrawquadraticcurve.md), [Image](../image.md)