# image.drawPoint()

Draws a point at the specified (x,y) coordinate.

```
image.drawPoint( x=number, y=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the point. |  |
| y | number | Yes | The y coordinate of the point. |  |

# Examples

```cfml
	img=imageNew("",100,100,"RGB","3c6382");
	img.DrawPoint(45,50);
	img.DrawPoint(46,49);
	img.DrawPoint(47,48);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawPoint()](../../functions/imagedrawpoint.md), [Image](../image.md)