# image.drawOval()

Draws an oval.

```
image.drawOval( x=number, y=number, width=number, height=number, filled=boolean )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the upper left corner of the oval to draw. |  |
| y | number | Yes | The y coordinate of the upper left corner of the oval to draw. |  |
| width | number | Yes | The width of the oval to draw. |  |
| height | number | Yes | The height of the oval to draw. |  |
| filled | boolean | No | Specify whether the oval is filled: - true: The oval is filled with the specified drawing color. - false (default): Only the outline of the oval is drawn. |  |

# Examples

```cfml
	img=imageNew("",200,200,"RGB","e55039");
	img.DrawOval(60,20,50,60,"no");
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawOval()](../../functions/imagedrawoval.md), [Image](../image.md)