# image.drawLine()

Draws a single line defined by two sets of x and y coordinates on a image.

```
image.drawLine( x1=number, y1=number, x2=number, y2=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x1 | number | Yes | The x coordinate for the start point of the line. |  |
| y1 | number | Yes | The y coordinate for the start point of the line. |  |
| x2 | number | Yes | The x coordinate for the end point of the line. |  |
| y2 | number | Yes | The y coordinate for the end point of the line. |  |

# Examples

```cfml
	img=imageNew("",200,200,"RGB","##bf4f36");
	img.DrawLine(0,0,200,180);
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawLine()](../../functions/imagedrawline.md), [Image](../image.md)