# image.drawCubicCurve()

Draws a cubic curve.

```
image.drawCubicCurve( x1=number, y1=number, ctrlx1=number, ctrly1=number, ctrlx2=number, ctrly2=number, x2=number, y2=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x1 | number | Yes | The x coordinate of the start point of the cubic curve segment. |  |
| y1 | number | Yes | The y coordinate of the start point of the cubic curve segment. |  |
| ctrlx1 | number | Yes | The x coordinate of the first control point of the cubic curve segment. |  |
| ctrly1 | number | Yes | The y coordinate of the first control point of the cubic curve segment. |  |
| ctrlx2 | number | Yes | The x coordinate of the second control point of the cubic curve segment. |  |
| ctrly2 | number | Yes | The y coordinate of the second control point of the cubic curve segment. |  |
| x2 | number | Yes | The x coordinate of the end point of the cubic curve segment. |  |
| y2 | number | Yes | The y coordinate of the end point of the cubic curve segment. |  |

# Examples

```cfml
	img=imageNew("",100,100,"RGB","3c6382");
	img.DrawCubicCurve(0,45,45,75,40,75,0,100);
	cfimage(action="writeToBrowser",source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawCubicCurve()](../../functions/imagedrawcubiccurve.md), [Image](../image.md)