# image.drawArc()

Draws a circular or elliptical arc.

```
image.drawArc( x=number, y=number, width=number, height=number, startAngle=number, arcAngle=number, filled=boolean )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the upper-left corner of the arc. |  |
| y | number | Yes | The y coordinate of the upper-left corner of the arc. |  |
| width | number | Yes | The width of the arc. |  |
| height | number | Yes | The height of the arc. |  |
| startAngle | number | Yes | The beginning angle in degrees. |  |
| arcAngle | number | Yes | The angular extent of the arc, relative to the start angle. |  |
| filled | boolean | No | Specify whether the arc is filled: - true: The arc is filled with the specified drawing color. - false (default): Only the outline of the arc is drawn. |  |

# Examples

```cfml
	img=imageRead("https://avatars1.githubusercontent.com/u/10973141?s=280&v=4")
	img.DrawArc(70,50,70,100,90,180,"yes");
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageDrawArc()](../../functions/imagedrawarc.md), [Image](../image.md)