# image.crop()

Crops a image to a specified rectangular area.

```
image.crop( x=number, y=number, width=number, height=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The X origin of the crop area. |  |
| y | number | Yes | The Y origin of the crop area. |  |
| width | number | Yes | The width of the crop area. |  |
| height | number | Yes | The height of the crop area. |  |

# Examples

```cfml
	img=imageRead("https://dev.lucee.org/uploads/default/original/2X/1/140e7bb0f8069e4f7f073b6d01f55c496bbd42e3.png");
	img.Crop(50,40,100,100);
	cfimage(action="writeToBrowser", source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageCrop()](../../functions/imagecrop.md), [Image](../image.md)