# image.copy()

Copies a rectangular area of an image.

```
image.copy( x=number, y=number, width=number, height=number, dx=number, dy=number )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The x coordinate of the source rectangle. |  |
| y | number | Yes | The y coordinate of the source rectangle. |  |
| width | number | Yes | The width of the source rectangle. |  |
| height | number | Yes | The height of the source rectangle. |  |
| dx | number | No | The x coordinate of the destination rectangle. |  |
| dy | number | No | The y coordinate of the destination rectangle. |  |

# Examples

```cfml
	newImg = imageNew("",200,200,"rgb","red");
	copiedImg = newImg.copy(50,50,50,50);
	cfimage(action="writeToBrowser", source=copiedImg);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageCopy()](../../functions/imagecopy.md), [Image](../image.md)