# image.clearRect()

Clears the specified rectangle by filling it with the background color of the current drawing surface.

```
image.clearRect( x=number, y=number, width=number, height=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| x | number | Yes | The X coordinate of the rectangle to clear. |  |
| y | number | Yes | The Y coordinate of the rectangle to clear. |  |
| width | number | Yes | The width of the rectangle to clear. |  |
| height | number | Yes | The height of the rectangle to clear. |  |

# Examples

```cfml
	imgRect = imageRead("https://pbs.twimg.com/profile_images/1037639083135250433/fREb9ZhM_400x400.jpg");
	imgRect.clearrect(250,150,70,80);
	cfimage (action="writeToBrowser" source=imgRect);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageClearRect()](../../functions/imageclearrect.md), [Image](../image.md)