# image.blur()

Smooths image.

```
image.blur( blurRadius=number )
```

**Returns:** image

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| blurRadius | number | No | The size of the blur radius. Value must be greater than or equal to 3 and less than or equal to 10. The default value is 3. |  |

# Examples

```cfml
	img = imageRead("https://dev.lucee.org/uploads/default/original/2X/1/140e7bb0f8069e4f7f073b6d01f55c496bbd42e3.png");
	img.blur(10);
	cfimage (action="writeToBrowser" source=img);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageBlur()](../../functions/imageblur.md), [Image](../image.md)