# image.addBorder()

Adds a rectangular border around the outside edge of a image.

```
image.addBorder( thickness=number, color=string, borderType=string )
```

**Returns:** void

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| thickness | number | No | Thickness of the border in pixels. The default value is 1. The border is added to the outside edge of the image; the image area is increased accordingly. |  |
| color | string | No | Optional. Border color. The default border color is black. See Usage. Only valid if the borderType is not specified or if borderType = "constant". *Alias: colour* |  |
| borderType | string | No | The type of border: - zero: Sets the border color to black. - constant: Sets the border to the specified color (default). - copy: Sets sample values to copies of the nearest valid pixel. For example, pixels to the left of the valid rectangle assume the value of the valid edge pixel in the same row. Pixels both above and to the left of the valid rectangle assume the value of the upper-left pixel. - reflect: Mirrors the edges of the source image. For example, if the left edge of the valid rectangle is located at x = 10, pixel (9, y) is a copy of pixel (10, y) and pixel (6, y) is a copy of pixel (13, y). - wrap: Tiles the source image in the plane. *Alias: type, border* |  |

# Examples

```cfml
	newImg = imageNew("",200,200,"rgb","red");
	newImg.addborder(10,"blue");
	cfimage(action = "writeToBrowser", source = newImg);
```

# Categories

[Image manipulation](../../../categories/image.md)

# See Also

[ImageAddBorder()](../../functions/imageaddborder.md), [Image](../image.md)