# Image

Object

- [image.addBorder()](image/addborder.md) - Adds a rectangular border around the outside edge of an image. The border can be a solid color or generated using various edge extension methods. The original image remains centered while the border increases the image dimensions.
- [image.blur()](image/blur.md) - Applies a box blur filter to smooth an image by averaging pixel values within a square region. Useful for reducing image noise or creating soft focus effects.
- [image.clearRect()](image/clearrect.md) - Clears the specified rectangle by filling it with the background color of the current drawing surface.
- [image.coderInfo()](image/coderinfo.md) - Gives detailed information about all coder used by the image extension.
- [image.copy()](image/copy.md) - Creates a new image by copying a rectangular area from the source image. If destination coordinates are provided, the copied area is also drawn at the new location in the resulting image.
- [image.crop()](image/crop.md) - Crops an image to a specified rectangular area. The function modifies the original image by extracting the defined region. If the specified crop area extends beyond the image boundaries, the function automatically adjusts to fit within the image dimensions.
- [image.drawArc()](image/drawarc.md) - Draws a circular or elliptical arc.
- [image.drawBeveledRect()](image/drawbeveledrect.md) - Draws a rectangle with beveled edges.
- [image.drawCubicCurve()](image/drawcubiccurve.md) - Draws a cubic curve.
- [image.drawDrawLines()](image/drawdrawlines.md) - Draws a sequence of connected lines defined by arrays of x and y coordinates.
- [image.drawImage()](image/drawimage.md) - this function is deprecated, use ImagePaste instead. Draws a image on a image with the baseline of the first character positioned at (x,y) in the image.
- [image.drawLine()](image/drawline.md) - Draws a single line defined by two sets of x and y coordinates on a image.
- [image.drawOval()](image/drawoval.md) - Draws an oval.
- [image.drawPoint()](image/drawpoint.md) - Draws a point at the specified (x,y) coordinate.
- [image.drawQuadraticCurve()](image/drawquadraticcurve.md) - Draws a curved line. The curve is controlled by a single point.
- [image.drawRect()](image/drawrect.md) - Draws a rectangle.
- [image.drawRoundRect()](image/drawroundrect.md) - Draws a rectangle with rounded corners.
- [image.drawText()](image/drawtext.md) - Draws a text string on a image with the baseline of the first character positioned at (x,y) in the image.
- [image.filter()](image/filter.md) - Executes a filter on the given image
- [image.filterColorMap()](image/filtercolormap.md) - These are passed to the function ImageFilters (see ImageFilter documentation) which convert gray values to colors.
- [image.flip()](image/flip.md) - Transforms an image by flipping or rotating it along specified axes. This operation modifies the original image in place.
- [image.getBlob()](image/getblob.md) - Retrieves the bytes of the underlying image. The bytes are in the same image format as the source image.
- [image.getBufferedImage()](image/getbufferedimage.md) - Returns the java.awt.BufferedImage object underlying the current image.
- [image.getEXIFMetadata()](image/getexifmetadata.md) - Retrieves the Exchangeable Image File Format (EXIF) headers in an image as a CFML structure.
- [image.getEXIFTag()](image/getexiftag.md) - Retrieves the specified EXIF tag in an image.
- [image.getHeight()](image/getheight.md) - Retrieves the height of the image in pixels.
- [image.getIptcMetadata()](image/getiptcmetadata.md) - Retrieves the International Press Telecommunications Council (IPTC )headers in a image as a struct. The IPTC metadata contains text that describes the image that is stored with it. IPTC metadata includes, but is not limited to, caption, keywords, credit, copyright, object name, created date, byline, headline, and source.
- [image.getWidth()](image/getwidth.md) - Retrieves the width of the specified image.
- [image.grayscale()](image/grayscale.md) - Converts a image to grayscale.
- [image.info()](image/info.md) - Returns a structure containing image information. When called with an image argument, returns details about the specific image including height, width, color model, size, and filename. When called without arguments, returns information about the Lucee image processing extension including its OSGi bundle version and status.
- [image.negative()](image/negative.md) - Creates a negative version of the image by inverting all pixel values. Each color channel value is subtracted from 255, resulting in opposite colors (e.g., white becomes black, red becomes cyan).
- [image.overlay()](image/overlay.md) - Combines two images by overlaying one on top of the other using alpha compositing. The second image is blended with the first based on its transparency.
- [image.paste()](image/paste.md) - Composites one image onto another at specified coordinates. The second image is overlaid on top of the first image, preserving transparency and using high-quality interpolation.
- [image.readBase64()](image/readbase64.md) - Creates a image from a Base64 string.
- [image.resize()](image/resize.md) - Resizes a image.
- [image.rotate()](image/rotate.md) - Rotates a image at a specified point by a specified angle.
- [image.rotateDrawingAxis()](image/rotatedrawingaxis.md) - Rotates all subsequent drawing on a image at a specified point by a specified angle.
- [image.scaleToFit()](image/scaletofit.md) - Creates a resized image with the aspect ratio maintained.
- [image.setAntialiasing()](image/setantialiasing.md) - Switches antialiasing on or off in rendered graphics.
- [image.setBackgroundColor()](image/setbackgroundcolor.md) - Sets the background color for the image. The background color is used for clearing a region. Setting the background color only affects the subsequent ImageClearRect calls
- [image.setDrawingAlpha()](image/setdrawingalpha.md) - Sets the current drawing alpha for images. All subsequent graphics operations use the specified alpha.
- [image.setDrawingColor()](image/setdrawingcolor.md) - Sets the current drawing color for images. All subsequent graphics operations use the specified color.
- [image.setDrawingStroke()](image/setdrawingstroke.md) - Sets the drawing stroke for points and lines in subsequent images.
- [image.setDrawingTransparency()](image/setdrawingtransparency.md) - Specifies the degree of transparency of drawing functions.
- [image.sharpen()](image/sharpen.md) - Enhances image clarity by applying an unsharp mask filter. 
This technique works by:
1. Creating a blurred copy of the original image
2. Finding edges by comparing differences
3. Enhancing edge contrast where differences are found
*Note:* Despite the name "unsharp mask", this process actually increases sharpness.
- [image.shear()](image/shear.md) - Transforms an image by shearing it along one axis, creating a slanted or skewed effect. Positive values slant in one direction, negative values in the opposite direction.
- [image.shearDrawingAxis()](image/sheardrawingaxis.md) - Shears the drawing canvas.
- [image.translate()](image/translate.md) - Moves an image to a new position by specified x and y offsets. The original image content is cleared and redrawn at the new location.
- [image.translateDrawingAxis()](image/translatedrawingaxis.md) - Translates the origin of the image context to the point (x,y) in the current coordinate system.
Modifies the image context so that its new origin corresponds to the point (x,y) in the image's original coordinate system.
- [image.write()](image/write.md) - Writes a image to the specified filename or destination.
- [image.writeBase64()](image/writebase64.md) - Writes Base64 images to the specified filename and destination.
- [image.writeToBrowser()](image/writetobrowser.md) - Writes image to browser.
- [image.XORDrawingMode()](image/xordrawingmode.md) - Sets the paint mode of the image to alternate between the image's current color and the new specified color.

# Categories

[Image manipulation](../../categories/image.md), [Objects](../../categories/object.md)

# See Also

[ImageNew()](../functions/imagenew.md)