# datetime.timeFormat()

Formats a time string to a given output

```
datetime.timeFormat( mask=string, timezone=timezone )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | string | No | Characters that show how Lucee displays a time: - h: hours; no leading zero for single-digit hours (12-hour clock) - hh: hours; leading zero for single-digit hours (12-hour clock) - H: hours; no leading zero for single-digit hours (24-hour clock) - HH: hours; leading zero for single-digit hours (24-hour clock) - m: minutes; no leading zero for single-digit minutes - mm: minutes; a leading zero for single-digit minutes - s: seconds; no leading zero for single-digit seconds - ss: seconds; leading zero for single-digit seconds - l or L: milliseconds, with no leading zeros - t: one-character time marker string, such as A or P - tt: multiple-character time marker string, such as AM or PM - z: Time zone in literal format, for example, IST - Z: Time zone in hours of offset (RFC 822 TimeZone), for example, +0530 - X: Time zone in hours of offset in ISO 8601 format. The following are the three ways of using 'X': + X: +05 + XX: +0530 + XXX: +5:30 - short: equivalent to h:mm tt - medium: equivalent to h:mm:ss tt - long: equivalent to h:mm:ss tt {timezone-3-letters} - full: equivalent to h:mm:ss tt {timezone-3-letters} |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	dt=CreateDateTime(1997,04,11,15,09,27);
	writeDump(dt.TimeFormat("hh:mm:ss"));
```

# Categories

[Date and time](../../../categories/datetime.md), [Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[TimeFormat()](../../functions/timeformat.md), [DateTime](../datetime.md)