# datetime.LSDateTimeFormat()

Formats a date string to a given output using the current locale

```
datetime.lSDateTimeFormat( mask=string, locale=locale, timezone=timezone )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | string | No | Mask that has to be used for formatting. The function follows Java date time mask. For details, see the section Date and Time Patterns at the following URL: <https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html> |  |
| locale | locale | No | Locale to use instead of the locale of the page when processing the function |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	list = "arabic (united arab emirates),hindi(India),arabic (syria),spanish (panama)";
	loop list="#list#" index="locale" delimiters="," {
		oldlocale = setLocale(locale);
		writeOutput("<h3>#locale#</h3>");
		writeoutput(now().lsdateTimeFormat());writeOutput("<br>");
		writeoutput(now().lsdateTimeFormat( 'hh:mm:ss'));writeOutput("<br>");
		writeoutput(now().lsdateTimeFormat( 'hh:mm:sst'));writeOutput("<br>");
		writeoutput(now().lsdateTimeFormat( 'hh:mm:sstt'));writeOutput("<br>");
		writeoutput(now().lsdateTimeFormat( 'HH:mm:ss'));
	}
```

# Categories

[Date and time](../../../categories/datetime.md), [Formatting](../../../categories/formatting.md), [Strings](../../../categories/string.md)

# See Also

[LSDateTimeFormat()](../../functions/lsdatetimeformat.md), [DateTime](../datetime.md)