# datetime.diff()

Determines the number of given date parts between two different dates

With Lucee 6, the order of the arguments for this `.diff()` member function was changed to match ACF

[LDEV-2044](https://luceeserver.atlassian.net/browse/LDEV-2044)

```
datetime.diff( datePart=string, date1=datetime )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| datePart | string | Yes | String that specifies the units in which to count: - yyyy: Years - q: Quarters - m: Months - y: Day of Year (same as d) - d: Days (same as y) - w: Weeks (same as ww) - ww: Weeks (same as w) - h: Hours - n: Minutes - s: Seconds |  |
| date1 | datetime | Yes | date time object to compare |  |

# Examples

```cfml
	date = createDateTime(1997,04,11);
	echo( date.Diff("d", "1997-04-25") & "<br>"); // 1
	dateOne = createDate(1997,04,11);
	echo( dateOne.Diff("d", "1997-04-11") & "<br>"); // 0
	datetime = createDateTime(1992,12,11,01,00,00);
	echo( datetime.Diff("h", "1992-12-11 00:00:00") & "<br>"); // -1
```

# Categories

[Date and time](../../../categories/datetime.md)

# See Also

[DateDiff()](../../functions/datediff.md), [DateTime](../datetime.md)