# datetime.daysInYear()

Determines the number of days in a year.

```
datetime.daysInYear( timezone=timezone )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	date = now();
	writeOutput("Total number of days for the current Year is "& date.daysInYear());
	datetime = createdate(2020,04,11);
	writeOutput("<br>Total number of days for the current Year is "& datetime.daysInYear());
```

# Categories

[Date and time](../../../categories/datetime.md)

# See Also

[DaysInYear()](../../functions/daysinyear.md), [DateTime](../datetime.md)