# datetime.dateTimeFormat()

Formats a date/time string to a given output

```
datetime.dateTimeFormat( mask=string, timezone=timezone )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | string | No | Mask that has to be used for formatting. the following characters are pattern letters (case sensitive) representing the components of a datetime string. All other characters are not interpreted - a,..,aaaa: AM/PM marker (see also "t" and "tt"; Example:AM) - d: Day in month, no leading zero for single-digit days (Example:3) - dd: Day in month, leading zero for single-digit days (Example:03) - D: Day in year, no leading zero for single-digit days (Example:4) - DD: Day in month, leading zero for single-digit days (Example:04) - DDD: Day in month, 2 leading zero for single-digit days (Example:004) - E,EE,EEE: Day of week as a three-letter abbreviation (Example:Tue) - EEEE: Day of week as its full name (Example:Tuesday) - F: Day of week in month, no leading zero for single-digit days (Example:4) - FF: Day of week in month, leading zero for single-digit days (Example:04) - G,GG: Era designator (Example:AD) - h: Hour in am/pm (1-12), no leading zero for single-digit hours (Example:3) - hh: Hour in am/pm (1-12), leading zero for single-digit hours (Example:03) - H: Hour in day (0-23), no leading zero for single-digit hours (Example:14) - HH: Hour in day (00-23), leading zero for single-digit hours (Example:14) - k: Hour in day (1-24), no leading zero for single-digit hours (Example:15) - kk: Hour in day (1-24), leading zero for single-digit hours (Example:15) - K: Hour in am/pm (0-11), no leading zero for single-digit hours (Example:2) - KK: Hour in am/pm (0-11), leading zero for single-digit hours (Example:02) - l,L: milliseconds, with no leading zeros (Example:3) - ll,LL: milliseconds, leading zero for single-digit days (Example:03) - lll,LLL: milliseconds, 2 leading zero for single-digit days (Example:003) - m,M: Month as digits, no leading zero for single-digit months (Example:6) - mm,MM: Month as digits, leading zero for single-digit months (Example:06) - mmm,MMM: Month as a three-letter abbreviation (Example:Jun) - mmmm,MMMM: Month as its full name (Example:June) - n,N: minutes in hour, no leading zero for single-digit minutes (Example:3) - nn,NN: minutes in hour, leading zero for single-digit minutes (Example:03) - s,S: seconds in minute, no leading zero for single-digit seconds (Example:3) - ss,SS: seconds in minute, leading zero for single-digit seconds (Example:03) - t,T: one-character time marker string (Example:P) - tt,TT: multiple-character time marker string (Example:PM) - w: Week in year, no leading zero for single-digit hours (Example:27) - ww: Week in year, leading zero for single-digit hours (Example:27) - W: Week in month, no leading zero for single-digit hours (Example:2) - WW: Week in month, leading zero for single-digit hours (Example:02) - y,yy,yyy: Year as last two digits, leading zero for single-digit (Example:09) - yyyy: Year represented by four digits (Example:2009) - z,zz,zzz: General time zone as a 3 to 4 lettesr abbreviation (Example:PST) - zzzz: General time zone as its full name (Example:Pacific Standard Time) - Z,..,ZZZZ: RFC 822 time zone (Example:-0800) The following masks can be used to format the full date and time and may not be combined with other masks: - short: equivalent to "m/d/y h:nn tt" - medium: equivalent to "mmm d, yyyy h:nn:ss tt" - long: medium followed by three-letter time zone; i.e. "mmmm d, yyyy h:nn:ss tt zzz" - full: equivalent to "dddd, mmmm d, yyyy h:nn:ss tt zz" - ISO8601/ISO: equivalent to "yyyy-mm-dd'T'HH:nn:ssXXX" The function follows Java date time mask. For details, see the section Date and Time Patterns at <https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html> |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	// the below code formats the date & show all the parts as two digits
	dateTime = now();
	writedump(dateTime.dateFormat('yy-mm-dd'));
	//Day of the week as a three-letter abbreviation.
	writedump(dateTime.dateFormat('ddd,dd/mm/yyyy'));
	//Day of the week as its full name.
	writedump(dateTime.dateFormat('dddd,dd/mm/yyyy'));
	// the below code formats the month as short string notation
	writedump(dateTime.dateFormat('yyyy/mmm/dd'));
	// the below code formats the date & separate date parts with dot
	writedump(dateTime.dateFormat('yyyy.mmm.dd'));
	// the below code formats the date & show the full month in string
	writedump(dateTime.dateFormat('yyyy-mmmm-dd'));
	// the below code returns the date with the format of full, long, medium, short
	dt=createDate(1997,04,11);
	writedump(dt.dateFormat("full"));
	writedump(dt.dateFormat("long"));
	writedump(dt.dateFormat("medium"));
	writedump(dt.dateFormat("short"));
	//Member function, able to format the date as normal function with all possibilities
	d1=createDate(1996,10,27)
	writeDump(d1.dateFormat("MM/DD/YYYY"));
	writeDump(d1.dateFormat("dddd,MM/DD/YYYY"));
```

# Categories

[Date and time](../../../categories/datetime.md), [Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[DateTimeFormat()](../../functions/datetimeformat.md), [DateTime](../datetime.md)