# datetime.dateFormat()

Formats a date string to a given output

```
datetime.dateFormat( mask=string, timezone=timezone )
```

**Returns:** string

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| mask | string | No | Characters that show how Lucee displays a date: - d: Day of the month as digits; no leading zero for single-digit days. - dd: Day of the month as digits; leading zero for single-digit days. - ddd: Day of the week as a three-letter abbreviation. - dddd: Day of the week as its full name. - m: Month as digits; no leading zero for single-digit months. - mm: Month as digits; leading zero for single-digit months. - mmm: Month as a three-letter abbreviation. - mmmm: Month as its full name. - yy: Year as last two digits; leading zero for years less than 10. - yyyy: Year represented by four digits. - gg: Period/era string. Ignored. Reserved. The following masks tell how to format the full date and cannot be combined with other masks: - z: Time zone in literal format, for example, IST - Z: Time zone in hours of offset (RFC 822 TimeZone), for example, +0530 - X: Time zone in hours of offset in ISO 8601 format. The following are the three ways of using 'X': + X: +05 + XX: +0530 + XXX: +5:30 - short: equivalent to m/d/y - medium: equivalent to mmm d, yyyy - long: equivalent to mmmm d, yyyy - full: equivalent to dddd, mmmm d, yyyy |  |
| timezone | timezone | No | A datetime object is independent of a specific timezone, it is only an offset in milliseconds from 1970-1-1 00.00:00 UTC (Coordinated Universal Time). This means that the timezone only comes into play when you need specific information like hours in a day, minutes in a hour or which day it is since those calculations depend on the timezone. For these calculations, a timezone must be specified in order to translate the date object to something else. If you do not provide the timezone in the function call, it will default to the timezone specified in the Lucee Administrator (Settings/Regional), or the timezone specified for the current request using the function setTimezone. You can find a list of all available timezones in the Lucee administrator (Settings/Regional). Some examples of valid timezones: - AGT (for time in Argentina) - Europe/Zurich (for time in Zurich/Switzerland) - HST (Hawaiian Standard Time in the USA) - JVM (JVM / Server Default Timezone) |  |

# Examples

```cfml
	// the below code formats the date & show all the parts as two digits
	dateTime = now();
	writedump(dateTime.dateFormat('yy-mm-dd'));
	//Day of the week as a three-letter abbreviation.
	writedump(dateTime.dateFormat('ddd,dd/mm/yyyy'));
	//Day of the week as its full name.
	writedump(dateTime.dateFormat('dddd,dd/mm/yyyy'));
	// the below code formats the month as short string notation
	writedump(dateTime.dateFormat('yyyy/mmm/dd'));
	// the below code formats the date & separate date parts with dot
	writedump(dateTime.dateFormat('yyyy.mmm.dd'));
	// the below code formats the date & show the full month in string
	writedump(dateTime.dateFormat('yyyy-mmmm-dd'));
	// the below code returns the date with the format of full, long, medium, short
	dt=createDate(1997,04,11);
	writedump(dt.dateFormat("full"));
	writedump(dt.dateFormat("long"));
	writedump(dt.dateFormat("medium"));
	writedump(dt.dateFormat("short"));
	//Member function, able to format the date as normal function with all possibilities
	d1=createDate(1996,10,27)
	writeDump(d1.dateFormat("MM/DD/YYYY"));
	writeDump(d1.dateFormat("dddd,MM/DD/YYYY"));
```

# Categories

[Date and time](../../../categories/datetime.md), [Strings](../../../categories/string.md), [Formatting](../../../categories/formatting.md)

# See Also

[DateFormat()](../../functions/dateformat.md), [DateTime](../datetime.md)