# datetime.compare()

Compares to date, to the given optional resolution.

Returns -1 if date1 is before date2.
Returns 1 if date1 is after date2.
Returns 0 if equal

```
datetime.compare( date2=datetime, datePart=string )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| date2 | datetime | Yes | datetime object |  |
| datePart | string | No | Precision of the comparison: - s (default): Precise to the second - n: Precise to the minute - h: Precise to the hour - d: Precise to the day - m: Precise to the month - yyyy: Precise to the year |  |

# Examples

```cfml
	dateTime = now();
	writeDump(datetime.compare("11/04/1997"));
	dateTimeone = "11/04/1997";
	writeDump(dateTimeone.compare("11/04/1997"));
	dateTimetwo = "27/10/1996";
	writeDump(dateTimetwo.compare(now()));
	dateTimet1= createDateTime(1997,04,11,08,10,00);
	dateTimet2= createDateTime(1997,04,11,08,15,00);
	writeDump(dateTimet1.compare(dateTimet2));
```

# Categories

[Date and time](../../../categories/datetime.md)

# See Also

[DateCompare()](../../functions/datecompare.md), [DateTime](../datetime.md)