# datetime.add()

Adds units of time to a date.

```
datetime.add( datePart=string, number=number )
```

**Returns:** datetime

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| datePart | string | Yes | one of the following: - yyyy: Year - q: Quarter - m: Month - y: Day of year - d: Day - w: Weekday - ww: Week - h: Hour - n: Minute - s: Second - l: Millisecond |  |
| number | number | Yes | Number of units of datepart to add to date (positive, to get dates in the future; negative, to get dates in the past). Number must be an integer. |  |

# Examples

```cfml
	datetime = now();
	// the below code increments 5 days in actual date
	dump(datetime.add("d", 5));
	// the below code increments 10 milliseconds in actual date
	dump(datetime.add("l", 10));
	// the below code increments 60 seconds in actual date
	dump(datetime.add("s", 60));
	// the below code increments 60 minutes in actual date
	dump(datetime.add("n", 60));
	// the below code increments 2 hours in actual date
	dump(datetime.add("h", 2));
	// the below code increments 1 day in actual date
	dump(datetime.add("d", 1));
	// the below code increments 1 month in actual date
	dump(datetime.add("m", 1));
	// the below code increments 1 year in actual date
	dump(datetime.add("yyyy", 1));
```

# Categories

[Date and time](../../../categories/datetime.md)

# See Also

[DateAdd()](../../functions/dateadd.md), [DateTime](../datetime.md)