# array.splice()

Modifies an array by removing elements and adding new elements. 
			It starts from the index, removes as many elements as specified by elementCountForRemoval, 
			and puts the replacements starting from index position.
			Return the removed elements.

**Introduced:** 6.0.0.19

```
array.splice( index=numeric, length=numeric, replacements=array )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| index | numeric | Yes | The position at which to start modifying the array. If the index is greater than the length of the array, the index is set to the length of the array. If the index is less than 1, the index is set to 1. *Alias: offset* |  |
| length | numeric | No | The number of elements to be removed starting with the start index. If length is 0 or smaller than -1, no elements get removed. if length is -1 or GTE than array length-index, all elements after index get removed. *Alias: len, elementCountForRemoval* |  |
| replacements | array | No | Array to be added to the array starting with index. *Alias: replacement* |  |

# Examples

```cfml
	Days = ['Sun', 'Mon', 'Wed','Thurs', 'Fri' , 'Sat'];
	item = ['Tues'];
	Days.splice(3, 0, item);
	writedump(Days);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArraySplice()](../../functions/arraysplice.md), [Array](../array.md)