# array.sort()

Sorts array elements numerically or alphanumerically.

```
array.sort( sortType_or_closure=object, sort_order=string, locale_sensitive=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| sortType_or_closure | object | No | value can be a string or a closure/function. a string must be one of the following values: - "numeric": sorts numbers - "text": sorts text alphabetically, taking case into account (case sensitive) - "textnocase": sorts text alphabetically, without regard to case (case insensitive) if you define a closure/function, the closure/function must accept 2 parameters of any type and return: - -1, if first parameter is "smaller" than second parameter - 0, if first parameter is equal to second parameter - 1, first parameter is "bigger" than second parameter `function (any e1, any e2) { return -1/0/1;});` *Alias: sort_type, sortType, closure, function, udf, callback* |  |
| sort_order | string | No | Sort direction: - asc(default): ascending sort order - desc: descending sort order. *Alias: sortOrder* |  |
| locale_sensitive | boolean | No | if true, use locale sensitive sorting. *Alias: localeSensitive* |  |

# Examples

```cfml
myarray = ["one","two","THREE","fouR","five"];
res = myarray.sort("text","asc");
writeDump(res);
res = myarray.sort("text","desc");
writeDump(res);
res = myarray.sort("textnocase","asc");
writeDump(res);
res = myarray.sort("textnocase","desc");
writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md), [Sorting](../../../categories/sort.md)

# See Also

[ArraySort()](../../functions/arraysort.md), [Array](../array.md)