# array.some()

This function calls a given closure/function with every element in a given array and returns true, if one of the closure calls returns true.

```
array.some( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor [function(any value[, numeric index,array array]):boolean]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	newArray = ['a','b','c','b','d','b','e','f'];
	writedump(newArray);
	testOne = newArray.some(function(item,idx,arr){
	    return item == 'c';
	});
	writedump(testOne);
	testTwo = newArray.some(function(item,idx,arr){
	    return item == 'k';
	});
	writedump(testTwo);
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md)

# See Also

[ArraySome()](../../functions/arraysome.md), [Array](../array.md)