# array.slice()

Returns a new array, from the start position up to the count of elements

```
array.slice( offset=number, length=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| offset | number | Yes | start position in the original array to slice |  |
| length | number | No | maximum elements to slice from offset |  |

# Examples

```cfml
	myarray = ["one","two","three","TWO","five","Two"];
	res = myarray.slice(2,4);
	writedump(res);
	myarray = ["one","two","three","TWO","five","Two"];
	res = myarray.slice(3,4);
	writedump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArraySlice()](../../functions/arrayslice.md), [Array](../array.md)