# array.shift()

pops the first element from an array and shift the rest of the values to the left. In case the array is empty an exception is thrown, 
			unless the second argument "defaultValue" is provided, in that case that value is returned.

**Introduced:** 5.3.8.104

```
array.shift( defaultValue=any )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| defaultValue | any | No | this value is returned in case the array is empty |  |

# Examples

```cfml
numbers = [ 1, 2, 3, 4 ];
numbers.Shift( );
Dump( numbers ); // Outputs [ 2, 3, 4 ]

moreNumbers = [ 5, 6, 7, 8 ];
moreNumbers.Shift( );
Dump( numbers ); // Outputs [ 6, 7, 8 ]

someArray     = [ "one", "two", "three", "four" ];
someArray.Shift( );
Dump( someArray ); // Outputs [ "two", "three", "four" ]

```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayShift()](../../functions/arrayshift.md), [Array](../array.md)