# array.set()

In an one-dimensional array, sets the elements in a specified index range to a value.

Useful for initializing an array after a call to ArrayNew.

```
array.set( start_pos=number, end_pos=number, value=any )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| start_pos | number | Yes | Starting index position of range to set. *Alias: start, startPos* |  |
| end_pos | number | Yes | Ending index position of range to set. If this value is greater than array length, Lucee adds elements to array. *Alias: end, endPos* |  |
| value | any | Yes | Value to which to set each element in the range. |  |

# Examples

```cfml
myarray = [];
res = myarray.set(1,4,"all is well");
writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArraySet()](../../functions/arrayset.md), [Array](../array.md)