# array.resize()

Resets an array to a specified minimum number of elements.
This can improve performance, if used to size an array to its
expected maximum. For more than 500 elements, use ArrayResize
immediately after using the ArrayNew tag.

```
array.resize( minimum_size=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| minimum_size | number | Yes | minimum size of the array *Alias: minimum, size* |  |

# Examples

```cfml
	myarray = ["one","two","three","TWO","five","Two"];
	res = myarray.resize(4);
	writedump(res);
	res = myarray.resize(8);
	writedump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayResize()](../../functions/arrayresize.md), [Array](../array.md)