# array.reduce()

Iterates over every entry of the given array and calls the closure with every element.
This function will reduce the array to a single value and will return the value.

```
array.reduce( closure=function, initialValue=object )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(any result, object value, [, numeric index [, array]]){ return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

```cfml
	array = ["lucee","core","dev"];
	reduced = Array.Reduce(function(carry, value){
	    return carry & ' ' & value;
	}, '' );
	writedump( reduced ); // yields 'lucee core dev'
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md), [Threads](../../../categories/thread.md)

# See Also

[ArrayReduce()](../../functions/arrayreduce.md), [Array](../array.md)