# array.prepend()

Inserts an array element at the beginning of an array
and shifts the positions of the existing elements to
make room.

```
array.prepend( value=any, merge=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value | any | Yes | value to prepend |  |
| merge | boolean | No | This argument only applies when the value is an array. If set to true prepend array elements individually to the source array. If false (default) the complete array is added as one element at the top, in the source array. |  |

# Examples

```cfml
	testArray = ["cat","tiger","cow"];
	testArray.prepend("lion");
	writedump(testArray);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayPrepend()](../../functions/arrayprepend.md), [Array](../array.md)