# array.pop()

pops the last element from an array. In case the array is empty an exception is thrown, 
			unless the second argument "defaultValue" is provided, in that case that value is returned.

**Introduced:** 5.3.8.104

```
array.pop( defaultValue=any )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| defaultValue | any | No | this value is returned in case the array is empty |  |

# Examples

### Arraypop member examples

```cfml
	numbers = [ 1, 2, 3, 4 ];
	dump( numbers.pop( 0 ) ); // Outputs 4
	dump( numbers ); // Outputs [ 1, 2, 3 ]

	moreNumbers = [ 5, 6, 7, 8 ];
	dump( moreNumbers.pop( 4 ) ); // Outputs 8
	dump( moreNumbers ); // outputs [ 5, 6, 7 ]

	moreNumbers = [  ];
	dump( moreNumbers.pop( 4 ) ); // Outputs 4 (default)
	dump( moreNumbers ); // Outputs [  ];
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayPop()](../../functions/arraypop.md), [Array](../array.md)