# array.merge()

This function creates a new array with data from the two passed arrays. To add all the data from one array into another without creating a new array see the built in function ArrayAppend(arr1, arr2, true).

```
array.merge( array2=array, leaveIndex=boolean )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| array2 | array | Yes | second array |  |
| leaveIndex | boolean | No | defines whether the merged arrays will maintain their index values or if the second array will simply append to the first one. If both arrays contain the same index and you specified the parameter leaveIndex to true, the corresponding index in the resulting array will always contain the value of the index of the first array. |  |

# Examples

```cfml
myarray = ["one","two","three","four","five"];
myarray1 = ["six","seven","eight"];
res = myarray.merge(myarray1);
writeDump(res);
res = myarray1.merge(myarray);
writeDump(res);
res = myarray.merge(myarray1,true);
writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayMerge()](../../functions/arraymerge.md), [Array](../array.md)