# array.map()

Calls the given closure with every element in the given array.

the function returns an array that contains all values returned by the closure.

```
array.map( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(any value[, number index, array array]):any]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	aNames = ["Marcus","Sarah","Josefine"];
	writedump(aNames);
	newNames2 = aNames.map(function(item,index,arr){
	    return {'name':item};
	});
	writedump(newNames2);
```

# Categories

[Arrays](../../../categories/array.md), [Iterator](../../../categories/iterator.md), [Threads](../../../categories/thread.md)

# See Also

[ArrayMap()](../../functions/arraymap.md), [Array](../array.md)