# array.insertAt()

Inserts a value at the specified position in the array.
If the element is inserted before the end of the array, Lucee shifts the positions of all elements with a higher index to make room.

```
array.insertAt( position=number, value=any )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| position | number | Yes | The numerical index in the array where the new element will be inserted. Must be less than or equal to the length of the array. Remember CFML arrays start at 1 not 0. |  |
| value | any | Yes | value to insert |  |

# Examples

```cfml
myarray = ["one","two","three","four","five"];
res = myarray.insertat("3",3);
writeDump(res);
res = myarray.insertat("1","start");
writeDump(res);
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayInsertAt()](../../functions/arrayinsertat.md), [Array](../array.md)