# array.findAll()

These functions searches the array for the specified object and return the positions of all occurrence of this values.

```
array.findAll( value_or_closure=any )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| value_or_closure | any | Yes | - The value to find - A closure/function that gets every value of the array as input and returns true if the given value is right, with the following signature: `boolean function(el){}` *Alias: object, value, closure, function, udf, callback* |  |

# Examples

```cfml
	numbers = [ "one", "two", "three", "four", "one", "one", "two", "one" ];
	dump( numbers.findall( "one" ) ) ; // [ 1,5, 6, 8 ]

	fruits = [ "apple", "orange", "banana", "orange", "orange" ];
	dump( fruits.findall( "orange" ) ); // [ 2, 4, 5 ]

	notOranges = arrayFindAll( fruits,
		function( el ){ 
			return arguments.el neq 'oranges';
	});
	dump( notOranges ); // [ 1, 3 ]
```

# Categories

[Arrays](../../../categories/array.md)

# See Also

[ArrayFindAll()](../../functions/arrayfindall.md), [Array](../array.md)